package org.measureyourgradient;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.Vector;

import javax.help.HelpSet;
import javax.swing.JApplet;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ScrollPaneConstants;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.SwingWorker;

class Compound
{
	String strCompoundName;
	int iCompoundIndex;

	static public int getCompoundNum()
	{
		return Globals.CompoundNameArray.length;
	}
	
	public boolean loadCompoundInfo(int iIndex)
	{
		iCompoundIndex = iIndex;
		
		strCompoundName = Globals.CompoundNameArray[iIndex];
		
		return true;
	}
}

public class MeasureYourGradientApplet extends JApplet implements ActionListener, KeyListener, FocusListener, ListSelectionListener, AutoScaleListener, TableModelListener, ClipboardOwner
{
	private static final long serialVersionUID = 1L;

	TopPanel contentPane = null;
	TopPanel2 contentPane2 = null;
	public JScrollPane jMainScrollPane = null;
	public JPanel jBackPanel = null;
	public int m_iStationaryPhase = 0;
	public double m_dColumnLength = 100; // in mm
	public double m_dColumnInnerDiameter = 2.1; // in mm
	public double m_dProgramTime = 20;
	public double m_dFlowRate = 1; // in mL/min
	public int m_iNumPoints = 3000;
	public Vector<Object[]> m_vectCalCompounds = new Vector<Object[]>(); //{compound #, measured retention time, projected retention time};
    private Task task = null;
    public int m_iStage = 1;
    public double m_dtstep = 0.01;
    public double m_V0 = 1; // in mL
    public double[][] m_dDeadVolumeArray;
    public double[][] m_dIdealGradientProfileArray;
    public LinearInterpolationFunction m_InterpolatedIdealGradientProfile; //Linear
    public InterpolationFunction m_InterpolatedGradientProfile;
    public InterpolationFunction m_InitialInterpolatedFlowRatevsTimeProfile;
    public double[][] m_dGradientProfileArray;
    public double[][] m_dFlowRateArray;
    public InterpolationFunction m_InterpolatedFlowRate;
    public InterpolationFunction[] m_StandardIsocraticDataInterpolated;
    public InterpolationFunction m_Vm;
	
    public double[][][] m_dFlowRateArrayStore;
    public double[][][] m_dGradientArrayStore;
    public double[] m_dRetentionErrorStore;

    public int m_iInterpolatedGradientProgramSeries = 0;
    public int m_iGradientProgramMarkerSeries = 0;
    public int m_iInterpolatedFlowRateSeries = 0;
    public int m_iFlowRateMarkerSeries = 0;
    
    public double m_dPlotXMax = 0;
    public double m_dPlotXMax2 = 0;
    
    public boolean m_bDoNotChangeTable = false;
    public final double m_dGoldenRatio = (1 + Math.sqrt(5)) / 2;

	public Vector<Compound> m_vectCompound = new Vector<Compound>();
	/**
	 * This is the xxx default constructor
	 */
	public MeasureYourGradientApplet() 
	{
	    super();
	    
		/*try {
	        //UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
	        UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
	    } 
	    catch (UnsupportedLookAndFeelException e) {
	       // handle exception
	    }
	    catch (ClassNotFoundException e) {
	       // handle exception
	    }
	    catch (InstantiationException e) {
	       // handle exception
	    }
	    catch (IllegalAccessException e) {
	       // handle exception
	    }*/

		this.setPreferredSize(new Dimension(943, 615));
	}

	/**
	 * This method initializes this
	 * 
	 * @return void
	 */
	public void init() 
	{
        // Load the JavaHelp
		String helpHS = "org/measureyourgradient/help/RetentionPredictorHelp.hs";
		ClassLoader cl = TopPanel.class.getClassLoader();
		try {
			URL hsURL = HelpSet.findHelpSet(cl, helpHS);
			Globals.hsMainHelpSet = new HelpSet(null, hsURL);
		} catch (Exception ee) {
			System.out.println( "HelpSet " + ee.getMessage());
			System.out.println("HelpSet "+ helpHS +" not found");
			return;
		}
		Globals.hbMainHelpBroker = Globals.hsMainHelpSet.createHelpBroker();

		//Execute a job on the event-dispatching thread; creating this applet's GUI.
        try {
        //    SwingUtilities.invokeAndWait(new Runnable() 
        //    {
        //        public void run() {
                	createGUI();
        //        }
        //    });
        } catch (Exception e) { 
            System.err.println("createGUI didn't complete successfully");
            System.err.println(e.getMessage());
            System.err.println(e.getLocalizedMessage());
            System.err.println(e.toString());
            System.err.println(e.getStackTrace());
            System.err.println(e.getCause());
        }
        
        performValidations();
        
    }
    
    private void createGUI()
    {
        //Create and set up the first content pane (steps 1-4).
    	jMainScrollPane = new JScrollPane();
    	jMainScrollPane.setHorizontalScrollBarPolicy(ScrollPaneConstants.HORIZONTAL_SCROLLBAR_AS_NEEDED);
    	jMainScrollPane.setVerticalScrollBarPolicy(ScrollPaneConstants.VERTICAL_SCROLLBAR_AS_NEEDED);

    	contentPane = new TopPanel();
        contentPane.setOpaque(true);
        jMainScrollPane.setViewportView(contentPane);
    	setContentPane(jMainScrollPane);
    	jMainScrollPane.revalidate();

        contentPane.jtxtColumnLength.addFocusListener(this);
        contentPane.jtxtColumnLength.addKeyListener(this);
        contentPane.jtxtInnerDiameter.addFocusListener(this);
        contentPane.jtxtInnerDiameter.addKeyListener(this);
        contentPane.jtxtFlowRate.addFocusListener(this);
        contentPane.jtxtFlowRate.addKeyListener(this);
        contentPane.jbtnHelp.addActionListener(this);
        contentPane.jbtnInsertRow.addActionListener(this);
        contentPane.jbtnRemoveRow.addActionListener(this);
       
        contentPane.m_GraphControlGradient.addAutoScaleListener(this);
        contentPane.m_GraphControlFlowRate.addAutoScaleListener(this);
        contentPane.tmGradientProgram.addTableModelListener(this);
        contentPane.tmMeasuredRetentionTimes.addTableModelListener(this);
        contentPane.jbtnNextStep.addActionListener(this);
        contentPane.jbtnPreloadedValues.addActionListener(this);
        
        contentPane.m_GraphControlGradient.setYAxisTitle("Eluent Composition (%B)");
        contentPane.m_GraphControlGradient.setYAxisBaseUnit("", "");
        contentPane.m_GraphControlGradient.setYAxisRangeLimits(0, 105);
        contentPane.m_GraphControlGradient.setYAxisRangeIndicatorsVisible(false);
        contentPane.m_GraphControlGradient.setXAxisRangeIndicatorsVisible(false);
        contentPane.m_GraphControlGradient.setAutoScaleY(true);
        contentPane.m_GraphControlGradient.repaint();

        contentPane.m_GraphControlFlowRate.setYAxisTitle("Flow Rate");
        contentPane.m_GraphControlFlowRate.setYAxisBaseUnit("liter/min", "L/min");
        contentPane.m_GraphControlFlowRate.setYAxisRangeLimits(0, 10000);
        contentPane.m_GraphControlFlowRate.setYAxisRangeIndicatorsVisible(false);
        contentPane.m_GraphControlFlowRate.setXAxisRangeIndicatorsVisible(false);
        contentPane.m_GraphControlFlowRate.setAutoScaleY(true);
        contentPane.m_GraphControlFlowRate.repaint();
        
        //Create and set up the second content pane
        contentPane2 = new TopPanel2();
        contentPane2.setOpaque(true); 
        
        contentPane2.jbtnCalculate.addActionListener(this);
        contentPane2.jbtnPreviousStep.addActionListener(this);
        contentPane2.jbtnHelp.addActionListener(this);

        contentPane2.m_GraphControlGradient.setYAxisTitle("Eluent Composition (%B)");
        contentPane2.m_GraphControlGradient.setYAxisBaseUnit("", "");
        contentPane2.m_GraphControlGradient.setYAxisRangeLimits(0, 105);
        contentPane2.m_GraphControlGradient.setYAxisRangeIndicatorsVisible(false);
        contentPane2.m_GraphControlGradient.setXAxisRangeIndicatorsVisible(false);
        contentPane2.m_GraphControlGradient.setAutoScaleY(true);
        contentPane2.m_GraphControlGradient.repaint();

        contentPane2.m_GraphControlFlowRate.setYAxisTitle("Flow Rate (mL/min)");
        contentPane2.m_GraphControlFlowRate.setYAxisBaseUnit("liter/min", "L/min");
        contentPane2.m_GraphControlFlowRate.setYAxisRangeLimits(0, 100);
        contentPane2.m_GraphControlFlowRate.setYAxisRangeIndicatorsVisible(true);
        contentPane2.m_GraphControlFlowRate.setAutoScaleY(true);
        //contentPane2.m_GraphControlHoldUp.setXAxisType(false);
        //contentPane2.m_GraphControlHoldUp.setXAxisBaseUnit("\u00b0C", "\u00b0C");
        //contentPane2.m_GraphControlHoldUp.setXAxisRangeLimits(0, 1000);
        //contentPane2.m_GraphControlHoldUp.setXAxisTitle("Temperature");
        contentPane2.m_GraphControlFlowRate.setXAxisRangeIndicatorsVisible(false);
        contentPane2.m_GraphControlFlowRate.repaint();       
    }

    private void validateColumnLength()
    {
    	if (contentPane.jtxtColumnLength.getText() == null)
    		contentPane.jtxtColumnLength.setText("0");
    	
		double dTemp = (double)Float.valueOf(contentPane.jtxtColumnLength.getText());
		
		if (dTemp < 0.1)
			dTemp = 0.1;
		if (dTemp > 10000)
			dTemp = 10000;
		
		this.m_dColumnLength = dTemp;
		contentPane.jtxtColumnLength.setText(Float.toString((float)m_dColumnLength));    	
    }

    private void validateColumnInnerDiameter()
    {
    	if (contentPane.jtxtInnerDiameter.getText() == null)
    		contentPane.jtxtInnerDiameter.setText("0");

    	double dTemp = (double)Float.valueOf(contentPane.jtxtInnerDiameter.getText());
		
		if (dTemp < 0.01)
			dTemp = 0.01;
		if (dTemp > 10000)
			dTemp = 10000;
		
		this.m_dColumnInnerDiameter = dTemp;
		contentPane.jtxtInnerDiameter.setText(Float.toString((float)m_dColumnInnerDiameter));    	
    }
    
    private void validateFlowRate()
    {
    	if (contentPane.jtxtFlowRate.getText() == null)
    		contentPane.jtxtFlowRate.setText("0");

    	double dTemp = (double)Float.valueOf(contentPane.jtxtFlowRate.getText());
		
		if (dTemp < 0.000000001)
			dTemp = 0.000000001;
		if (dTemp > 10000)
			dTemp = 10000;
		
		this.m_dFlowRate = dTemp;
		contentPane.jtxtFlowRate.setText(Float.toString((float)m_dFlowRate));    	
    }
    
	class CompoundSorter implements Comparator 
	{
		int colIndex;
	
		CompoundSorter(int colIndex) 
		{
			this.colIndex = colIndex;
		}
	
		public int compare(Object a, Object b) 
		{
		    Object o1 = ((Object[])a)[colIndex];
		    Object o2 = ((Object[])b)[colIndex];
	
		    if (o1 instanceof String && ((String) o1).length() == 0) {
		      o1 = null;
		    }
		    if (o2 instanceof String && ((String) o2).length() == 0) {
		      o2 = null;
		    }
	
		    if (o1 == null && o2 == null) {
		    	return 0;
		    } else if (o1 == null) {
		    	return 1;
		    } else if (o2 == null) {
		    	return -1;
		    } else if (o1 instanceof Comparable) {
	
		    	return ((Comparable) o1).compareTo(o2);
		    } else {
	
		    	return o1.toString().compareTo(o2.toString());
		    }
		}
	}

    public void nextStepButtonPressed()
    {
    	// Set the graph and flow profiles to contain the correct data
    	m_iStage = 2;

    	// Set initial control values
    	contentPane2.jbtnCalculate.setText("Back-Calculate Profiles");
    	contentPane2.jbtnCalculate.setEnabled(true);
		contentPane2.jbtnCalculate.setActionCommand("Calculate");
    	contentPane2.jlblIterationNumber.setText("1");
    	contentPane2.jlblLastVariance.setText("");
    	contentPane2.jlblPercentImprovement.setText("");
    	contentPane2.jlblPhase.setText("I");
    	contentPane2.jlblTimeElapsed.setText("");
    	contentPane2.jlblVariance.setText("");
    	contentPane2.jProgressBar.setString("");
    	contentPane2.jProgressBar.setIndeterminate(false);
    	contentPane2.m_GraphControlGradient.RemoveAllSeries();
    	contentPane2.m_GraphControlFlowRate.RemoveAllSeries();
        contentPane2.jpanelStep5.setVisible(true);
		
		// Create dead volume array
        this.m_dDeadVolumeArray = new double[Globals.dDeadVolumeArray.length][2];
        
        for (int i = 0; i < Globals.dDeadVolumeArray.length; i++)
        {
        	double dVolumeInRefColumn = Math.PI * Math.pow(0.21, 2) * 10.0;
        	double dDeadVolPerVol = Globals.dDeadVolumeArray[i][1] / dVolumeInRefColumn;
        	double dNewDeadVol = dDeadVolPerVol * Math.PI * Math.pow(this.m_dColumnInnerDiameter / 10, 2) * this.m_dColumnLength / 10;
        	this.m_dDeadVolumeArray[i][0] = Globals.dDeadVolumeArray[i][0];
        	this.m_dDeadVolumeArray[i][1] = dNewDeadVol;
        }
        
        // Find greatest dead volume
		double dVmMax = 0;
		
		for (int i = 0; i < this.m_dDeadVolumeArray.length; i++)
		{
			if (this.m_dDeadVolumeArray[i][1] > dVmMax)
			{
				dVmMax = this.m_dDeadVolumeArray[i][1];
			}
		}	  
		
    	// Set the table to contain the correct data
    	contentPane2.tmOutputModel.getDataVector().clear();
    	m_vectCalCompounds.clear();
    	
    	for (int i = 0; i < contentPane.tmMeasuredRetentionTimes.getRowCount(); i++)
    	{
    		if ((Double)contentPane.tmMeasuredRetentionTimes.getValueAt(i, 3) <= (Double)0.0
    				|| (Boolean)contentPane.tmMeasuredRetentionTimes.getValueAt(i, 0) == false)
    			continue;
    		
    		Object[] newRow = {contentPane.tmMeasuredRetentionTimes.getValueAt(i, 1), contentPane.tmMeasuredRetentionTimes.getValueAt(i, 3), null, null};

    		contentPane2.tmOutputModel.addRow(newRow);
    		
			Object[] newSolute = {i, contentPane.tmMeasuredRetentionTimes.getValueAt(i, 3), (Double)0.0};
			m_vectCalCompounds.add(newSolute);
    	}
    	
    	// Sort the calibration compounds by their retention times
        Collections.sort(m_vectCalCompounds, new CompoundSorter(1));
    	
		m_dPlotXMax2 = (((Double)m_vectCalCompounds.get(m_vectCalCompounds.size() - 1)[1])) - (0.5 * (dVmMax / this.m_dFlowRate));
    	
    	// Here is where we set the value of m_dtstep
    	m_dtstep = m_dPlotXMax2 * 0.001;

    	int iIdealPlotIndexGradient = contentPane2.m_GraphControlGradient.AddSeries("Ideal Gradient Program", new Color(0, 0, 0), 1, false, false);
    	int iIdealPlotIndexFlowRate = contentPane2.m_GraphControlFlowRate.AddSeries("Ideal Flow Rate", new Color(0, 0, 0), 1, false, false);

    	m_iInterpolatedGradientProgramSeries = contentPane2.m_GraphControlGradient.AddSeries("Interpolated Gradient Program", new Color(255,0,0), 1, false, false);
	    m_iGradientProgramMarkerSeries = contentPane2.m_GraphControlGradient.AddSeries("Gradient Program Markers", new Color(255,0,0), 1, true, false);
    	
    	m_iInterpolatedFlowRateSeries = contentPane2.m_GraphControlFlowRate.AddSeries("Interpolated Flow Rate", new Color(255,0,0), 1, false, false);
	    m_iFlowRateMarkerSeries = contentPane2.m_GraphControlFlowRate.AddSeries("Flow Rate Markers", new Color(255,0,0), 1, true, false);

	    // Add in data points for the ideal gradient program series
	    
    	this.m_dIdealGradientProfileArray = new double[contentPane.tmGradientProgram.getRowCount() + 2][2];
    	int iPointCount = 0;

    	contentPane2.m_GraphControlGradient.AddDataPoint(iIdealPlotIndexGradient, 0, (Double)contentPane.tmGradientProgram.getValueAt(0, 1));	
    	this.m_dIdealGradientProfileArray[iPointCount][0] = 0.0;
    	this.m_dIdealGradientProfileArray[iPointCount][1] = (Double)contentPane.tmGradientProgram.getValueAt(0, 1);
    	double dLastTime = 0;
		iPointCount++;
		
    	// Go through the gradient program table and create an array that contains solvent composition vs. time
		for (int i = 0; i < contentPane.tmGradientProgram.getRowCount(); i++)
		{
    		if ((Double)contentPane.tmGradientProgram.getValueAt(i, 0) > dLastTime)
    		{
    			double dTime = (Double)contentPane.tmGradientProgram.getValueAt(i, 0);
    			double dFractionB = (Double)contentPane.tmGradientProgram.getValueAt(i, 1);
    			
    	    	contentPane2.m_GraphControlGradient.AddDataPoint(iIdealPlotIndexGradient, dTime * 60, dFractionB);	
				this.m_dIdealGradientProfileArray[iPointCount][0] = dTime;
				this.m_dIdealGradientProfileArray[iPointCount][1] = dFractionB;
    	    	iPointCount++;
    		
    	    	dLastTime = dTime;
    		}
		}
		
		contentPane2.m_GraphControlGradient.AddDataPoint(iIdealPlotIndexGradient, m_dPlotXMax2 * 60, (Double)contentPane.tmGradientProgram.getValueAt(contentPane.tmGradientProgram.getRowCount() - 1, 1));
		this.m_dIdealGradientProfileArray[iPointCount][0] = m_dPlotXMax2 * 60;
		this.m_dIdealGradientProfileArray[iPointCount][1] = (Double)contentPane.tmGradientProgram.getValueAt(contentPane.tmGradientProgram.getRowCount() - 1, 1);
    	iPointCount++;

		// Ideal series finished
		// Now cut it down to the correct size
		double tempArray[][] = new double[iPointCount][2];
		for (int i = 0; i < iPointCount; i++)
		{
			tempArray[i][0] = this.m_dIdealGradientProfileArray[i][0];
			tempArray[i][1] = this.m_dIdealGradientProfileArray[i][1];
		}
		this.m_dIdealGradientProfileArray = tempArray;
		
		// Make the interpolated gradient profile
    	this.m_InterpolatedIdealGradientProfile = new LinearInterpolationFunction(this.m_dIdealGradientProfileArray);

    	// Select number of data points for the gradient and flow profiles
		int iTotalDataPoints = m_vectCalCompounds.size();
		
		// 11/15ths of the data points should be on the gradient profile
		int iNumGradientProgramDataPoints = (int)(((double)11 / (double)15)*(double)iTotalDataPoints);
		int iNumFlowDataPoints = iTotalDataPoints - iNumGradientProgramDataPoints;
		
		if (iNumFlowDataPoints < 3)
		{
			iNumFlowDataPoints = 3;
			iNumGradientProgramDataPoints = iTotalDataPoints - iNumFlowDataPoints;
		}
		
		// Create initial gradient and flow rate arrays
		
		// First make an array with the correct number of data points.
		m_dGradientProfileArray = new double [iNumGradientProgramDataPoints][2];
		m_dFlowRateArray = new double [iNumFlowDataPoints][2];
		
		// Set the value of the first data point
		m_dGradientProfileArray[0][0] = 0;
		m_dGradientProfileArray[0][1] = this.m_InterpolatedIdealGradientProfile.getAt(m_dGradientProfileArray[0][0]);
		
		for (int i = 1; i < iNumGradientProgramDataPoints - 1; i++)
		{
			// Find the two nearest standards
			double dStandardNum = ((double)i / ((double)iNumGradientProgramDataPoints - 1)) * (double)iTotalDataPoints;
			double dOneGreater = (int)Math.ceil(dStandardNum);
			double dOneLesser = (int)Math.floor(dStandardNum);
			double dRtOneLesser = (Double)m_vectCalCompounds.get((int)dOneLesser)[1];
			double dRtOneGreater = (Double)m_vectCalCompounds.get((int)dOneGreater)[1];
		
			// Check to see if we landed exactly on an alkane
			if (dOneGreater == dOneLesser)
			{
				// If so, set the time of this point to the alkane we landed on
				m_dGradientProfileArray[i][0] = dRtOneLesser;
			}
			else
			{
				// Otherwise, find the time of this point in between the surrounding alkanes
				double dPosition = ((dStandardNum - dOneLesser) / (dOneGreater - dOneLesser));
				m_dGradientProfileArray[i][0] = (dPosition * dRtOneGreater) + ((1 - dPosition) * dRtOneLesser);
			}
			
			// Subtract half a hold-up time
			m_dGradientProfileArray[i][0] = m_dGradientProfileArray[i][0] - (0.5 * (dVmMax / this.m_dFlowRate));
			m_dGradientProfileArray[i][1] = m_InterpolatedIdealGradientProfile.getAt(m_dGradientProfileArray[i][0]);
		}
		
		// Add the last data point at the position of the last-eluting compound - half dead time
		m_dGradientProfileArray[iNumGradientProgramDataPoints - 1][0] = (Double)m_vectCalCompounds.get(m_vectCalCompounds.size() - 1)[1] - (0.5 * (dVmMax / this.m_dFlowRate));
		m_dGradientProfileArray[iNumGradientProgramDataPoints - 1][1] = m_InterpolatedIdealGradientProfile.getAt(m_dGradientProfileArray[iNumGradientProgramDataPoints - 1][0]);
		
		// Now adjust to get points at the corners
		int iPointIndex = 1;
		// Run through each corner in the ideal gradient profile array
		for (int i = 1; i < this.m_dIdealGradientProfileArray.length - 1; i++)
		{
			double dFirst = 0;
			double dNext = 0;
			
			// Find the first point after the corner (dNext) and the first point before the corner (dFirst)
			while (dNext < this.m_dIdealGradientProfileArray[i][0] && iPointIndex < m_dGradientProfileArray.length - 1)
			{
				dFirst = m_dGradientProfileArray[iPointIndex][0];
				dNext = m_dGradientProfileArray[iPointIndex + 1][0];
				
				iPointIndex++;
			}
			
			// Remove the last increment
			iPointIndex--;
			
			// Find the distances between the corner and the two points
			double dDistFirst = this.m_dIdealGradientProfileArray[i][0] - dFirst;
			double dDistNext = dNext - this.m_dIdealGradientProfileArray[i][0];
			
			// Find the distances between the two points and their next further point
			double dDistFirstBefore = m_dGradientProfileArray[iPointIndex][0] - m_dGradientProfileArray[iPointIndex - 1][0];
			double dDistNextAfter;
			if (iPointIndex + 2 < m_dGradientProfileArray.length)
				dDistNextAfter = m_dGradientProfileArray[iPointIndex + 2][0] - m_dGradientProfileArray[iPointIndex + 1][0];
			else
				dDistNextAfter = 0;
			
			double dScoreFirst = dDistFirst + dDistFirstBefore;
			double dScoreNext = dDistNext + dDistNextAfter;
			
			// Point with lower score moves
			if (dScoreFirst < dScoreNext)
			{
				// Move the first point
				m_dGradientProfileArray[iPointIndex][0] = this.m_dIdealGradientProfileArray[i][0];
				m_dGradientProfileArray[iPointIndex][1] = m_InterpolatedIdealGradientProfile.getAt(m_dGradientProfileArray[iPointIndex][0]);

				// Move the one before it right in between it and the last point
				if (iPointIndex >= 2)
				{
					m_dGradientProfileArray[iPointIndex - 1][0] = (m_dGradientProfileArray[iPointIndex - 2][0] + m_dGradientProfileArray[iPointIndex][0]) / 2;
					m_dGradientProfileArray[iPointIndex - 1][1] = m_InterpolatedIdealGradientProfile.getAt(m_dGradientProfileArray[iPointIndex - 1][0]);
				}
				
				// Move the one after it in between it and the next point
				if (iPointIndex <= m_dGradientProfileArray.length - 3)
				{
					m_dGradientProfileArray[iPointIndex + 1][0] = (m_dGradientProfileArray[iPointIndex][0] + m_dGradientProfileArray[iPointIndex + 2][0]) / 2;
					m_dGradientProfileArray[iPointIndex + 1][1] = m_InterpolatedIdealGradientProfile.getAt(m_dGradientProfileArray[iPointIndex + 1][0]);
				}
				
			}
			else
			{
				// Move the next point
				m_dGradientProfileArray[iPointIndex + 1][0] = this.m_dIdealGradientProfileArray[i][0];
				m_dGradientProfileArray[iPointIndex + 1][1] = m_InterpolatedIdealGradientProfile.getAt(m_dGradientProfileArray[iPointIndex + 1][0]);

				// Move the one before it right in between it and the last point
				if (iPointIndex >= 1)
				{
					m_dGradientProfileArray[iPointIndex][0] = (m_dGradientProfileArray[iPointIndex - 1][0] + m_dGradientProfileArray[iPointIndex + 1][0]) / 2;
					m_dGradientProfileArray[iPointIndex][1] = m_InterpolatedIdealGradientProfile.getAt(m_dGradientProfileArray[iPointIndex][0]);
				}
				
				// Move the one after it in between it and the next point
				if (iPointIndex <= m_dGradientProfileArray.length - 4)
				{
					m_dGradientProfileArray[iPointIndex + 2][0] = (m_dGradientProfileArray[iPointIndex + 1][0] + m_dGradientProfileArray[iPointIndex + 3][0]) / 2;
					m_dGradientProfileArray[iPointIndex + 2][1] = m_InterpolatedIdealGradientProfile.getAt(m_dGradientProfileArray[iPointIndex + 2][0]);
				}
			}
		}

    	// Now for the flow rate vs. time profile:
		
    	// Add the initial interpolated hold-up time profile to the graph control
	    int iNumPoints = 1000;
	    for (int i = 0; i < iNumPoints; i++)
	    {
	    	double dXPos = (((double)i / (double)(iNumPoints - 1)) * this.m_dPlotXMax2);
	    	contentPane2.m_GraphControlFlowRate.AddDataPoint(iIdealPlotIndexFlowRate, dXPos * 60, this.m_dFlowRate / 1000);
	    }

	    for (int i = 0; i < iNumFlowDataPoints; i++)
		{
			m_dFlowRateArray[i][0] = (this.m_dPlotXMax2 * ((double)i/((double)iNumFlowDataPoints - 1)));
			m_dFlowRateArray[i][1] = this.m_dFlowRate;
		}
		
		m_InterpolatedGradientProfile = new InterpolationFunction(m_dGradientProfileArray);
		m_InterpolatedFlowRate = new InterpolationFunction(m_dFlowRateArray);

		//setContentPane(contentPane2);
		this.jMainScrollPane.setViewportView(contentPane2);
		this.updateGraphs(false);
    }
    
    public void actionPerformed(ActionEvent evt) 
	{
	    String strActionCommand = evt.getActionCommand();

	    if (strActionCommand == "Help")
	    {
			Globals.hbMainHelpBroker.setCurrentID("step-by-step");
			Globals.hbMainHelpBroker.setDisplayed(true);
	    }
	    else if (strActionCommand == "Next Step")
	    {
	    	nextStepButtonPressed();
	    }
	    else if (strActionCommand == "Previous Step")
	    {
			if (m_iStage == 2)
			{
				//setContentPane(contentPane);
				this.jMainScrollPane.setViewportView(contentPane);

				if (task != null)
				{
					task.cancel(true);	
				}
				m_iStage = 1;
			}
	    }
	    else if (strActionCommand == "Calculate")
	    {
	    	beginBackCalculation(false);
	    }
	    else if (strActionCommand == "Copy to clipboard")
	    {
	    	copyProfilesToClipboard();
	    }
	    else if (strActionCommand == "Stop Calculations")
	    {
	    	task.cancel(true);
	    }
	    else if (strActionCommand == "Preloaded Values")
	    {
	    	Frame[] frames = Frame.getFrames();
	    	PreloadedValuesDialog dlgPreloadedValues = new PreloadedValuesDialog(frames[0]);
	    	
	    	// Show the dialog.
	    	dlgPreloadedValues.setVisible(true);
	    	
	    	if (dlgPreloadedValues.m_bOk == false)
	    		return;
    		
    		contentPane.jtxtInnerDiameter.setText(((Double)Globals.dGradientPrograms[dlgPreloadedValues.m_iCondition][0][0]).toString());
    		contentPane.jtxtColumnLength.setText(((Double)Globals.dGradientPrograms[dlgPreloadedValues.m_iCondition][0][1]).toString());
    		contentPane.jtxtFlowRate.setText(((Double)Globals.dGradientPrograms[dlgPreloadedValues.m_iCondition][0][2]).toString());

    		/*int rowcount = contentPane.tmGradientProgram.getRowCount();
    		for (int i = 0; i < rowcount; i++)
    		{
        		contentPane.tmGradientProgram.removeRow(0);
    		}*/
    		
    		this.m_bDoNotChangeTable = true;
    		contentPane.tmGradientProgram.setRowCount(0);

    		for (int i = 1; i < Globals.dGradientPrograms[dlgPreloadedValues.m_iCondition].length; i++)
    		{
        		Object[] rowData = {
        				Globals.dGradientPrograms[dlgPreloadedValues.m_iCondition][i][0],
        				Globals.dGradientPrograms[dlgPreloadedValues.m_iCondition][i][1]};

    			contentPane.tmGradientProgram.addRow(rowData);
    		}
    		
	    	// Put in default values
	    	/*for (int i = 0; i < contentPane.tmMeasuredRetentionTimes.getRowCount(); i++)
	    	{
	    		contentPane.tmMeasuredRetentionTimes.setValueAt(0.0, i, 1);
	    	}*/
	    	
			for (int i = 0; i < Globals.dPredefinedValues[dlgPreloadedValues.m_iCondition].length; i++)
			{
	            contentPane.tmMeasuredRetentionTimes.setValueAt(Globals.dPredefinedValues[dlgPreloadedValues.m_iCondition][i], i, 3);
	            if (Globals.dPredefinedValues[dlgPreloadedValues.m_iCondition][i] > 0)
		            contentPane.tmMeasuredRetentionTimes.setValueAt(true, i, 0);	            	
	            else
		            contentPane.tmMeasuredRetentionTimes.setValueAt(false, i, 0);	            	
	            	
			}
	    	performValidations();
	    	
	    }
	    else if (strActionCommand == "Insert Row")
	    {
	    	int iSelectedRow = contentPane.jtableGradientProgram.getSelectedRow();
	    	
	    	if (iSelectedRow == -1)
	    		iSelectedRow = contentPane.tmGradientProgram.getRowCount()-1;
	    	
	    	Double dRowValue1 = (Double) contentPane.tmGradientProgram.getValueAt(iSelectedRow, 0);
	    	Double dRowValue2 = (Double) contentPane.tmGradientProgram.getValueAt(iSelectedRow, 1);
	    	Double dRowData[] = {dRowValue1, dRowValue2};
	    	contentPane.tmGradientProgram.insertRow(iSelectedRow + 1, dRowData);
	    }
	    else if (strActionCommand == "Remove Row")
	    {
	    	int iSelectedRow = contentPane.jtableGradientProgram.getSelectedRow();
	    	
	    	if (iSelectedRow == -1)
	    		iSelectedRow = contentPane.tmGradientProgram.getRowCount()-1;
	    	
	    	if (contentPane.tmGradientProgram.getRowCount() >= 3)
	    	{
	    		contentPane.tmGradientProgram.removeRow(iSelectedRow);
	    	}
	    }
	}
    
    public void copyProfilesToClipboard()
    {
    	// Make a string that can be pasted into Excel
    	String outString = "";
    	String eol = System.getProperty("line.separator");
    	// First create the heading
    	// Programmed conditions
    	outString += "Programmed (initial) experimental conditions" + eol;
    	outString += "Stationary phase:\t" + Globals.StationaryPhaseArray[this.contentPane.jcboStationaryPhase.getSelectedIndex()] + eol;
    	outString += "Column inner diameter:\t" + this.contentPane.jtxtInnerDiameter.getText() + " mm" + eol;
    	outString += "Column length:\t" + this.contentPane.jtxtColumnLength.getText() + " mm" + eol;
    	outString += "Flow rate:\t" + this.contentPane.jtxtFlowRate.getText() + " mL/min" + eol;
    	outString += "Gradient program:" + eol;
    	outString += "Time (min)\tEluent composition (%B)" + eol;
    	for (int i = 0; i < this.contentPane.tmGradientProgram.getRowCount(); i++)
    	{
    		outString += contentPane.tmGradientProgram.getValueAt(i, 0) + "\t" + contentPane.tmGradientProgram.getValueAt(i, 1) + eol;
    	}
    	outString += eol;
    	
    	// Standards, experimental, calculated, and error
    	outString += "Retention times of standards" + eol;
    	outString += "Standard\tExperimental retention time (min)\tCalculated retention time (min)\tDifference (min)" + eol;
    	for (int i = 0; i < this.contentPane2.tmOutputModel.getRowCount(); i++)
    	{
    		outString += this.contentPane2.tmOutputModel.getValueAt(i, 0) + "\t" + this.contentPane2.tmOutputModel.getValueAt(i, 1) + "\t" + this.contentPane2.tmOutputModel.getValueAt(i, 2) + "\t" + this.contentPane2.tmOutputModel.getValueAt(i, 3) + eol;
    	}
    	outString += eol;
    	
    	outString += "Back-calculated gradient profile\t\t\tBack-calculated flow rate profile" + eol;
    	outString += "Time (min)\tEluent composition (%B)\t\tTime(min)\tFlow rate (mL/min)" + eol;
    	
    	int iNumPoints = 1000;
    	for (int i = 0; i < iNumPoints; i++)
    	{
    		double dCurrentTime = this.m_dPlotXMax2 * ((double)i / ((double)iNumPoints - 1));
    		double dCurrentSolventComposition = this.m_InterpolatedGradientProfile.getAt(dCurrentTime);
    		double dCurrentFlowRate = this.m_InterpolatedFlowRate.getAt(dCurrentTime);
    		
    		outString += Float.toString((float)dCurrentTime) + "\t" + Float.toString((float)dCurrentSolventComposition) + "\t\t" + Float.toString((float)dCurrentTime) + "\t" + Float.toString((float)dCurrentFlowRate) + eol;
    	}
    	
    	StringSelection stringSelection = new StringSelection(outString);
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(stringSelection, this);
        
        JOptionPane.showMessageDialog(null, "A report has been copied to the clipboard. You may now paste it into a spreadsheet.", "Measure Your Gradient", JOptionPane.INFORMATION_MESSAGE);
    }
    
	//@Override
	public void keyPressed(KeyEvent arg0) 
	{
		
	}

	//@Override
	public void keyReleased(KeyEvent e) 
	{

	}

	//@Override
	public void keyTyped(KeyEvent e) 
	{
		//JTextField source = (JTextField)e.getSource();
		
		if (!((Character.isDigit(e.getKeyChar()) ||
				(e.getKeyChar() == KeyEvent.VK_BACK_SPACE) ||
				(e.getKeyChar() == KeyEvent.VK_DELETE) ||
				(e.getKeyChar() == KeyEvent.VK_PERIOD))))
		{
	        e.consume();
		}
		
		if (e.getKeyChar() == KeyEvent.VK_ENTER)
		{
			performValidations();
		}
		
	}

	public void performValidations()
	{
		validateColumnLength();
		validateColumnInnerDiameter();
		validateFlowRate();
		
		m_V0 = (Math.PI * Math.pow((this.m_dColumnInnerDiameter / 10) / 2, 2) * (this.m_dColumnLength / 10)) / 1000; // gives the volume in the column (in L)

		// Find longest retention time
		double dLongestRetentionTime = 0;
		for (int i = 0; i < contentPane.tmMeasuredRetentionTimes.getRowCount(); i++)
		{
			double dValue = (Double)contentPane.tmMeasuredRetentionTimes.getValueAt(i, 3);
			if (dValue > dLongestRetentionTime)
				dLongestRetentionTime = dValue;
		}

		double dLastProgramTime = (Double)contentPane.tmGradientProgram.getValueAt(contentPane.tmGradientProgram.getRowCount() - 1, 0);
		m_dPlotXMax = Math.max(dLongestRetentionTime * 1.1, dLastProgramTime * 1.1);
		
    	contentPane.m_GraphControlGradient.RemoveAllSeries();
    	contentPane.m_GraphControlFlowRate.RemoveAllSeries();

    	int iIdealPlotIndex = contentPane.m_GraphControlGradient.AddSeries("Ideal Gradient", new Color(0, 0, 0), 1, false, false);
    	int iIdealPlotIndexHoldUp = contentPane.m_GraphControlFlowRate.AddSeries("Ideal Hold Up", new Color(0, 0, 0), 1, false, false);

    	contentPane.m_GraphControlFlowRate.AddDataPoint(iIdealPlotIndexHoldUp, 0, this.m_dFlowRate / 1000);
    	contentPane.m_GraphControlFlowRate.AddDataPoint(iIdealPlotIndexHoldUp, m_dPlotXMax * 60, this.m_dFlowRate / 1000);

    	contentPane.m_GraphControlGradient.AddDataPoint(iIdealPlotIndex, 0, (Double)contentPane.tmGradientProgram.getValueAt(0, 1));	
    	double dLastTime = 0;
    	
    	for (int i = 0; i < contentPane.tmGradientProgram.getRowCount(); i++)
		{
    		if ((Double)contentPane.tmGradientProgram.getValueAt(i, 0) > dLastTime)
    		{
    			double dTime = (Double)contentPane.tmGradientProgram.getValueAt(i, 0);
    			double dFractionB = (Double)contentPane.tmGradientProgram.getValueAt(i, 1);
    			
    	    	contentPane.m_GraphControlGradient.AddDataPoint(iIdealPlotIndex, dTime * 60, dFractionB);	
    		
    	    	dLastTime = dTime;
    		}
		}
    	
		contentPane.m_GraphControlGradient.AddDataPoint(iIdealPlotIndex, m_dPlotXMax * 60, (Double)contentPane.tmGradientProgram.getValueAt(contentPane.tmGradientProgram.getRowCount() - 1, 1));

   		contentPane.m_GraphControlGradient.AutoScaleX();
   		contentPane.m_GraphControlGradient.AutoScaleY();
    	
    	contentPane.m_GraphControlGradient.repaint();   
    	
   		contentPane.m_GraphControlFlowRate.AutoScaleX();
   		contentPane.m_GraphControlFlowRate.AutoScaleY();
    	
    	contentPane.m_GraphControlFlowRate.repaint();   	
	}

	//@Override
	public void focusGained(FocusEvent e) 
	{
		
	}

	//@Override
	public void focusLost(FocusEvent e) 
	{
		performValidations();
	}

	//@Override
	public void valueChanged(ListSelectionEvent arg0) 
	{
		performValidations();
		
	}
	
	//@Override
	public void autoScaleChanged(AutoScaleEvent event) 
	{
		//if(event.getSource()==contentPane.m_GraphControl)
		//{
/*			if (event.getAutoScaleXState() == true)
				contentPane.jbtnAutoscaleX.setSelected(true);
			else
				contentPane.jbtnAutoscaleX.setSelected(false);
			
			if (event.getAutoScaleYState() == true)
				contentPane.jbtnAutoscaleY.setSelected(true);
			else
				contentPane.jbtnAutoscaleY.setSelected(false);
			
			if (event.getAutoScaleXState() == true && event.getAutoScaleYState() == true)
				contentPane.jbtnAutoscale.setSelected(true);			
			else
				contentPane.jbtnAutoscale.setSelected(false);	
		}
		else if (event.getSource()==contentPane.m_GraphControlFlow)
		{
			if (event.getAutoScaleXState() == true)
				contentPane.jbtnAutoscaleXFlow.setSelected(true);
			else
				contentPane.jbtnAutoscaleXFlow.setSelected(false);
			
			if (event.getAutoScaleYState() == true)
				contentPane.jbtnAutoscaleYFlow.setSelected(true);
			else
				contentPane.jbtnAutoscaleYFlow.setSelected(false);
			
			if (event.getAutoScaleXState() == true && event.getAutoScaleYState() == true)
				contentPane.jbtnAutoscaleFlow.setSelected(true);			
			else
				contentPane.jbtnAutoscaleFlow.setSelected(false);				
		}*/
	}

	@Override
	public void tableChanged(TableModelEvent e) 
	{
		if (m_bDoNotChangeTable)
		{
			m_bDoNotChangeTable = false;
			return;
		}
		
		if(e.getSource() == contentPane.tmGradientProgram)
		{
			if (m_bDoNotChangeTable)
			{
				m_bDoNotChangeTable = false;
				return;
			}
			
			int iChangedRow = e.getFirstRow();
			int iChangedColumn = e.getColumn();

			Double dRowValue1 = 0.0;
			Double dRowValue2 = 0.0;
			
			if (iChangedRow < contentPane.tmGradientProgram.getRowCount())
			{
				dRowValue1 = (Double) contentPane.tmGradientProgram.getValueAt(iChangedRow, 0);
				dRowValue2 = (Double) contentPane.tmGradientProgram.getValueAt(iChangedRow, 1);
			}
			
	    	if (iChangedColumn == 0)
			{
				// If the column changed was the first, then make sure the time falls in the right range
				if (iChangedRow == 0)
				{
					// No changes allowed in first row - must be zero min
					dRowValue1 = 0.0;
				}
				else if (iChangedRow == contentPane.tmGradientProgram.getRowCount() - 1)
				{
					Double dPreviousTime = (Double) contentPane.tmGradientProgram.getValueAt(contentPane.tmGradientProgram.getRowCount() - 2, 0);
					// If it's the last row, just make sure the time is greater than or equal to the time before it.
					if (dRowValue1 < dPreviousTime)
						dRowValue1 = dPreviousTime;
				}
				else
				{
					Double dPreviousTime = (Double) contentPane.tmGradientProgram.getValueAt(iChangedRow - 1, 0);
					Double dNextTime = (Double) contentPane.tmGradientProgram.getValueAt(iChangedRow + 1, 0);
					
					if (dRowValue1 < dPreviousTime)
						dRowValue1 = dPreviousTime;
					
					if (dRowValue1 > dNextTime)
						dRowValue1 = dNextTime;
				}
				
		    	m_bDoNotChangeTable = true;
		    	contentPane.tmGradientProgram.setValueAt(dRowValue1, iChangedRow, iChangedColumn);
			}
			else if (iChangedColumn == 1)
			{
				// If the column changed was the second, then make sure the solvent composition falls between 0 and 100
				if (dRowValue2 > 100)
					dRowValue2 = 100.0;
				
				if (dRowValue2 < 0)
					dRowValue2 = 0.0;
				
		    	m_bDoNotChangeTable = true;
		    	contentPane.tmGradientProgram.setValueAt(dRowValue2, iChangedRow, iChangedColumn);
			}
		}
		else if (e.getSource() == contentPane.tmMeasuredRetentionTimes)
		{
			int iChangedRow = e.getFirstRow();
			int iChangedColumn = e.getColumn();

			if (iChangedColumn == 3)
			{
		    	if (contentPane.tmMeasuredRetentionTimes.getValueAt(iChangedRow, 3) == null)
		    	{
			    	m_bDoNotChangeTable = true;
		    		contentPane.tmMeasuredRetentionTimes.setValueAt((Double)0.0, iChangedRow, 3);
		    	}
		    	
		    	double dNewValue = (Double)contentPane.tmMeasuredRetentionTimes.getValueAt(iChangedRow, 3);
				
				if (dNewValue < 0)
					dNewValue = 0;
				if (dNewValue > 9999999)
					dNewValue = 9999999;
				
		    	m_bDoNotChangeTable = true;
	    		contentPane.tmMeasuredRetentionTimes.setValueAt((Double)dNewValue, iChangedRow, 3);
				
		    	m_bDoNotChangeTable = true;
	    		if (dNewValue <= 0)
	    			contentPane.tmMeasuredRetentionTimes.setValueAt((Boolean)false, iChangedRow, 0);
	    		else
	    			contentPane.tmMeasuredRetentionTimes.setValueAt((Boolean)true, iChangedRow, 0);
			}
		}
		
		performValidations();
		
		contentPane.m_GraphControlGradient.removeAllLineMarkers();
		contentPane.m_GraphControlFlowRate.removeAllLineMarkers();
		
		for (int i = 0; i < contentPane.tmMeasuredRetentionTimes.getRowCount(); i++)
		{
			if ((Boolean)contentPane.tmMeasuredRetentionTimes.getValueAt(i,0) == true)
			{
				contentPane.m_GraphControlGradient.addLineMarker((Double)contentPane.tmMeasuredRetentionTimes.getValueAt(i,3), (String)contentPane.tmMeasuredRetentionTimes.getValueAt(i,1));
				contentPane.m_GraphControlFlowRate.addLineMarker((Double)contentPane.tmMeasuredRetentionTimes.getValueAt(i,3), (String)contentPane.tmMeasuredRetentionTimes.getValueAt(i,1));
			}
		}

		contentPane.m_GraphControlGradient.repaint();
		contentPane.m_GraphControlFlowRate.repaint();
		
		// Make sure there are at least 6 used retention times
		int iNumUsed = 0;
		
		for (int i = 0; i < contentPane.tmMeasuredRetentionTimes.getRowCount(); i++)
		{
			if ((Boolean)contentPane.tmMeasuredRetentionTimes.getValueAt(i, 0) == true)
				iNumUsed++;
		}
		
		if (iNumUsed >= 6)
			contentPane.jbtnNextStep.setEnabled(true);
		else
			contentPane.jbtnNextStep.setEnabled(false);
	}
	
	public void updateGraphs(boolean bAlsoUpdateTable)
	{
		synchronized(contentPane2.m_GraphControlGradient.lockObject)
		{
		synchronized(contentPane2.m_GraphControlFlowRate.lockObject)
		{
		// Update the graphs with the new m_dGradientArray markers and the m_InterpolatedGradient (and the same with the flow graph)
		contentPane2.m_GraphControlGradient.RemoveSeries(m_iInterpolatedGradientProgramSeries);
		contentPane2.m_GraphControlGradient.RemoveSeries(m_iGradientProgramMarkerSeries);
		
		contentPane2.m_GraphControlFlowRate.RemoveSeries(m_iInterpolatedFlowRateSeries);
		contentPane2.m_GraphControlFlowRate.RemoveSeries(m_iFlowRateMarkerSeries);
		
	    m_iInterpolatedGradientProgramSeries = contentPane2.m_GraphControlGradient.AddSeries("Interpolated Gradient", new Color(255,0,0), 1, false, false);
	    m_iGradientProgramMarkerSeries = contentPane2.m_GraphControlGradient.AddSeries("Gradient Markers", new Color(255,0,0), 1, true, false);

	    m_iInterpolatedFlowRateSeries = contentPane2.m_GraphControlFlowRate.AddSeries("Interpolated Flow", new Color(255,0,0), 1, false, false);
	    m_iFlowRateMarkerSeries = contentPane2.m_GraphControlFlowRate.AddSeries("Flow Rate Markers", new Color(255,0,0), 1, true, false);

	    int iNumPoints = 1000;
	    for (int i = 0; i < iNumPoints; i++)
	    {
	    	double dXPos = ((double)i / (double)(iNumPoints - 1)) * (m_dPlotXMax2 * 60);
	    	contentPane2.m_GraphControlGradient.AddDataPoint(m_iInterpolatedGradientProgramSeries, dXPos, m_InterpolatedGradientProfile.getAt(dXPos / 60));
	    	contentPane2.m_GraphControlFlowRate.AddDataPoint(m_iInterpolatedFlowRateSeries, dXPos, m_InterpolatedFlowRate.getAt(dXPos / 60) / 1000);
	    }
	    
	    for (int i = 0; i < m_dGradientProfileArray.length; i++)
	    {
	    	contentPane2.m_GraphControlGradient.AddDataPoint(m_iGradientProgramMarkerSeries, m_dGradientProfileArray[i][0] * 60, m_dGradientProfileArray[i][1]);
	    }
		
	    for (int i = 0; i < m_dFlowRateArray.length; i++)
	    {
	    	contentPane2.m_GraphControlFlowRate.AddDataPoint(m_iFlowRateMarkerSeries, m_dFlowRateArray[i][0] * 60, m_dFlowRateArray[i][1] / 1000);
	    }
	    
	    //contentPane2.m_GraphControlGradient.AutoScaleX();
	    contentPane2.m_GraphControlGradient.AutoScaleToSeries(m_iInterpolatedGradientProgramSeries);
	    contentPane2.m_GraphControlGradient.AutoScaleY();
	    contentPane2.m_GraphControlFlowRate.AutoScaleX();
	    contentPane2.m_GraphControlFlowRate.AutoScaleY();
     
	    contentPane2.m_GraphControlGradient.repaint();
	    contentPane2.m_GraphControlFlowRate.repaint();

	    if (bAlsoUpdateTable)
	    {
			NumberFormat formatter = new DecimalFormat("#0.0000");
	
		    for (int i = 0; i < m_vectCalCompounds.size(); i++)
		    {
		    	double dMeasuredTime = (Double)m_vectCalCompounds.get(i)[1];
		    	double dPredictedTime = (Double)m_vectCalCompounds.get(i)[2];
		    	if (dPredictedTime >= 0)
		    	{
		    		contentPane2.tmOutputModel.setValueAt(formatter.format(dPredictedTime), i, 2);
		    		contentPane2.tmOutputModel.setValueAt(formatter.format(dPredictedTime - dMeasuredTime), i, 3);
		    	}
		    	else
		    	{
		    		contentPane2.tmOutputModel.setValueAt("Did not elute", i, 2);
		    		contentPane2.tmOutputModel.setValueAt("-", i, 3);
		    	}
		    }
	    }
	    
		}
		}
	}
	
	public void beginBackCalculation(boolean bFlowRateProfileBackCalculationFirst)
	{
		contentPane2.jbtnCalculate.setEnabled(false);
		//contentPane2.jbtnCalculate.setText("Please wait...");
		contentPane2.jProgressBar.setIndeterminate(true);
		contentPane2.jProgressBar.setStringPainted(true);
		contentPane2.jProgressBar.setString("Please wait, optimization in progress...");
        
       	task = new Task();
		task.setOptimizationOrder(bFlowRateProfileBackCalculationFirst);
        task.execute();
	}
	
    class Task extends SwingWorker<Void, Void> 
    {
        /*
         * Main task. Executed in background thread.
         */
    	private boolean bFlowRateProfileBackCalculationFirst = true;
    	
    	public void setOptimizationOrder(boolean bFlowRateProfileBackCalculationFirst)
    	{
    		this.bFlowRateProfileBackCalculationFirst = bFlowRateProfileBackCalculationFirst;
    	}
    	
        @Override
        public Void doInBackground() 
        {
            backCalculate(this, bFlowRateProfileBackCalculationFirst);

            return null;
        }
        
        /*
         * Executed in event dispatching thread
         */
        @Override
        public void done() 
        {
    		contentPane2.jProgressBar.setIndeterminate(false);
    		contentPane2.jProgressBar.setStringPainted(true);
    		contentPane2.jbtnCalculate.setText("Copy profiles to clipboard");
    		contentPane2.jbtnCalculate.setActionCommand("Copy to clipboard");
    		contentPane2.jbtnCalculate.setEnabled(true);
    		contentPane2.jProgressBar.setString("Optimization complete! Now copy profiles to clipboard.");
        }
    }
    
   /* public double calcRetentionError(double dtstep, int iNumCompoundsToInclude)
    {
		//NumberFormat formatter = new DecimalFormat("#0.0000");
    	double dRetentionError = 0;
		
		for (int iCompound = 0; iCompound < iNumCompoundsToInclude; iCompound++)
		{
			double dtRFinal = 0;
			double dXPosition = 0;
			double dLastXPosition = 0;
			double dXMovement = 0;
			boolean bIsEluted = false;
			double dPhiA = 0;
			double dPhiB = 0;
			double dCurVal = 0;
			
			dPhiA = m_InterpolatedGradientProfile.getAt(0);
			
			for (double t = 0; t <= (Double) m_vectCalCompounds.get(m_vectCalCompounds.size() - 1)[1] * 1.5; t += dtstep)
			{
				dPhiB = m_InterpolatedGradientProfile.getAt(t + dtstep);

				double dPhi = (dPhiA + dPhiB) / 2;
				double dHc = m_InterpolatedFlowRate.getAt(dTc) / 60;

				dCurVal = dtstep / (1 + Math.pow(10, m_StandardIsocraticDataInterpolated[iCompound].getAt(dTc)));
				
				dXMovement = dCurVal / dHc;
				
				dLastXPosition = dXPosition;
				dXPosition += dXMovement;
				
				if (dXPosition >= 1)
				{
					dtRFinal = (((1 - dLastXPosition)/(dXPosition - dLastXPosition)) * dtstep) + t;
					bIsEluted = true;
					break;
				}
				
				dTcA = dTcB;
			}
			
			if (bIsEluted)
			{
				dRetentionError += Math.pow(dtRFinal - (Double)m_vectCalCompounds.get(iCompound)[1], 2);
				m_vectCalCompounds.get(iCompound)[2] = dtRFinal;
				//contentPane2.tmOutputModel.setValueAt(formatter.format(dtRFinal), iCompound, 2);
				//contentPane2.tmOutputModel.setValueAt(formatter.format(dtRFinal - (Double)m_vectCalCompounds.get(iCompound)[1]), iCompound, 3);
			}
			else
			{
				dRetentionError += Math.pow((Double)m_vectCalCompounds.get(iCompound)[1], 2);
				m_vectCalCompounds.get(iCompound)[2] = -1;
				//contentPane2.tmOutputModel.setValueAt("Did not elute", iCompound, 2);
				//contentPane2.tmOutputModel.setValueAt("-", iCompound, 3);
			}
		}
				
    	return dRetentionError;
    }*/
    
    public double calcRetentionError(double dtstep, int iNumCompoundsToInclude)
    {
    	double dRetentionError = 0;
		
		for (int iCompound = 0; iCompound < iNumCompoundsToInclude; iCompound++)
		{
			double dIntegral = 0;
			double dtRFinal = 0;
			double dD = 0;
			double dTotalTime = 0;
			double dTotalDeadTime = 0;
			double dXPosition = 0;
			double[] dLastXPosition = {0,0};
			double[] dLastko = {0,0};
			double dXMovement = 0;
			Boolean bIsEluted = false;
			double dPhiC = 0;
			double dCurVal = 0;
			
			for (double t = 0; t <= (Double) m_vectCalCompounds.get(m_vectCalCompounds.size() - 1)[1] * 1.5; t += dtstep)
			{
				dPhiC = m_InterpolatedGradientProfile.getAt(dTotalTime - dIntegral) / 100;
				dCurVal = dtstep / (Math.pow(10, m_StandardIsocraticDataInterpolated[iCompound].getAt(dPhiC)));
				double dt0 = m_Vm.getAt(dPhiC)/m_InterpolatedFlowRate.getAt(dTotalTime - dIntegral);
				dXMovement = dCurVal / dt0;
				
				if (dXPosition >= 1)
				{
					dD = ((1 - dLastXPosition[0])/(dXPosition - dLastXPosition[0])) * (dTotalDeadTime - dLastXPosition[1]) + dLastXPosition[1]; 
				}
				else
				{
					dLastXPosition[0] = dXPosition;
					dLastXPosition[1] = dTotalDeadTime;
				}
				
				dTotalDeadTime += dXMovement * dt0;
				
				if (dXPosition >= 1)
				{
					dtRFinal = ((dD - dLastko[0])/(dIntegral - dLastko[0]))*(dTotalTime - dLastko[1]) + dLastko[1];
				}
				else
				{
					dLastko[0] = dIntegral;
					dLastko[1] = dTotalTime;
				}
				
				dTotalTime += dtstep + dCurVal;
				dIntegral += dCurVal;
				
				if (dXPosition > 1 && bIsEluted == false)
				{
					bIsEluted = true;
					break;
				}
				
				dXPosition += dXMovement;
			}
			
			if (bIsEluted)
			{
				dRetentionError += Math.pow(dtRFinal - (Double)m_vectCalCompounds.get(iCompound)[1], 2);
				m_vectCalCompounds.get(iCompound)[2] = dtRFinal;
			}
			else
			{
				dRetentionError += Math.pow((Double)m_vectCalCompounds.get(iCompound)[1], 2);
				m_vectCalCompounds.get(iCompound)[2] = (double)-1.0;
			}
		}
				
    	return dRetentionError;
    }
    
    public void updateTime(long starttime)
    {
		NumberFormat timeformatter = new DecimalFormat("00");
		
		long currentTime = System.currentTimeMillis();
		long lNumSecondsPassed = (currentTime - starttime) / 1000;
		long lNumDaysPassed = lNumSecondsPassed / (24 * 60 * 60);
		lNumSecondsPassed -= lNumDaysPassed * (24 * 60 * 60);
		long lNumHoursPassed = lNumSecondsPassed / (60 * 60);
		lNumSecondsPassed -= lNumHoursPassed * (60 * 60);
		long lNumMinutesPassed = lNumSecondsPassed / (60);
		lNumSecondsPassed -= lNumMinutesPassed * (60);
		
		String strProgress2 = "";
		strProgress2 += timeformatter.format(lNumHoursPassed) + ":" + timeformatter.format(lNumMinutesPassed) + ":" + timeformatter.format(lNumSecondsPassed);
		contentPane2.jlblTimeElapsed.setText(strProgress2);
    }
    
    public double calcAngleDifferenceFlowRate(int iIndex)
    {
    	double dTotalAngleError = 0;
    	double dHoldUpRange = 20;
    	
    	for (int i = 0; i < this.m_dFlowRateArray.length; i++)
    	{
        	if (i < 2)
        		continue;
        	
        	double dTime2 = this.m_dFlowRateArray[i][0];
        	double dHoldUp2 = this.m_dFlowRateArray[i][1];
        	double dTime1 = this.m_dFlowRateArray[i - 1][0];
        	double dHoldUp1 = this.m_dFlowRateArray[i - 1][1];
        	double dTime0 = this.m_dFlowRateArray[i - 2][0];
        	double dHoldUp0 = this.m_dFlowRateArray[i - 2][1];
        	
        	// First determine angle of previous segment
    		double dPreviousAdjacent = (dHoldUp1 - dHoldUp0) / dHoldUpRange;
    		double dPreviousOpposite = dTime1 - dTime0;
    		double dPreviousAngle;
    		if (dPreviousAdjacent == 0)
    			dPreviousAngle = Math.PI / 2; // 90 degrees
    		else
    			dPreviousAngle = Math.atan(dPreviousOpposite / dPreviousAdjacent);
    		
    		if (dPreviousAngle < 0)
    			dPreviousAngle = Math.PI + dPreviousAngle;
    		
    		double dAdjacent = (dHoldUp2 - dHoldUp1) / dHoldUpRange;
    		double dOpposite = dTime2 - dTime1;
    		double dNewAngle;
    		if (dAdjacent == 0)
    			dNewAngle = Math.PI / 2; // 90 degrees
    		else
    			dNewAngle = Math.atan(dOpposite / dAdjacent);
    		
    		if (dNewAngle < 0)
    			dNewAngle = Math.PI + dNewAngle;
    		
    		double dFactor1 = 300;
    		double dAngleError = Math.pow((Math.abs(dNewAngle - dPreviousAngle) / (Math.PI)) * dFactor1, 2) + 1;
    		dTotalAngleError += dAngleError;
    	}
    	
     	return dTotalAngleError;
    }
    
    public double calcAngleDifferenceGradient(int iIndex)
    {
    	double dTotalAngleError = 0;
    	double dMaxRampRate = 50;
    	
    	for (int i = 0; i < this.m_dGradientProfileArray.length; i++)
    	{
        	if (i < 2)
        		continue;
        	
        	double dTime2 = this.m_dGradientProfileArray[i][0];
        	double dTemp2 = this.m_dGradientProfileArray[i][1];
        	double dTime1 = this.m_dGradientProfileArray[i - 1][0];
        	double dTemp1 = this.m_dGradientProfileArray[i - 1][1];
        	double dTime0 = this.m_dGradientProfileArray[i - 2][0];
        	double dTemp0 = this.m_dGradientProfileArray[i - 2][1];
        	
        	// Check if the previous point is a corner
        	// If it is, then don't worry about the angle - return 0
    		boolean bIsCorner = false;
    		
        	for (int j = 0; j < this.m_dIdealGradientProfileArray.length - 1; j++)
    		{
    			if (this.m_dIdealGradientProfileArray[j][0] == dTime1)
    			{
    				bIsCorner = true;
    				break;
    			}
    		}
        	
        	if (bIsCorner)
        		continue;

    	   	// First determine angle of previous segment
    		double dPreviousAdjacent = (dTemp1 - dTemp0) / dMaxRampRate;
    		double dPreviousOpposite = dTime1 - dTime0;
    		double dPreviousAngle;
    		if (dPreviousAdjacent == 0)
    			dPreviousAngle = Math.PI / 2; // 90 degrees
    		else
    			dPreviousAngle = Math.atan(dPreviousOpposite / dPreviousAdjacent);
    		
    		if (dPreviousAngle < 0)
    			dPreviousAngle = Math.PI + dPreviousAngle;
    		
    		double dAdjacent = (dTemp2 - dTemp1) / dMaxRampRate;
    		double dOpposite = dTime2 - dTime1;
    		double dNewAngle;
    		if (dAdjacent == 0)
    			dNewAngle = Math.PI / 2; // 90 degrees
    		else
    			dNewAngle = Math.atan(dOpposite / dAdjacent);
    		
    		if (dNewAngle < 0)
    			dNewAngle = Math.PI + dNewAngle;
    		
    		double dFactor1 = 10;//30;
    		double dAngleError = Math.pow((Math.abs(dNewAngle - dPreviousAngle) / (Math.PI)) * dFactor1, 2) + 1;
    		dTotalAngleError += dAngleError;
    	}
    	
     	return dTotalAngleError;
    }
    
/*    public double calcAngleDifference3(int iIndex)
    {
    	if (iIndex <= 1)
    		return 1;
    	
    	double dMaxRampRate = 70;
    	
    	double dTime2 = this.m_dTemperatureProfileArray[iIndex][0];
    	double dTemp2 = this.m_dTemperatureProfileArray[iIndex][1];
    	double dTime1 = this.m_dTemperatureProfileArray[iIndex - 1][0];
    	double dTemp1 = this.m_dTemperatureProfileArray[iIndex - 1][1];
    	double dTime0 = this.m_dTemperatureProfileArray[iIndex - 2][0];
    	double dTemp0 = this.m_dTemperatureProfileArray[iIndex - 2][1];
    	
    	// Check if the previous point is a corner
    	// If it is, then don't worry about the angle - return 0
		for (int i = 0; i < this.m_dIdealTemperatureProfileArray.length - 1; i++)
		{
			if (this.m_dIdealTemperatureProfileArray[i][0] == dTime1)
				return 1;
		}
    	
    	// First determine angle of previous segment
		double dPreviousAdjacent = (dTemp1 - dTemp0) / dMaxRampRate;
		double dPreviousOpposite = dTime1 - dTime0;
		double dPreviousAngle;
		if (dPreviousAdjacent == 0)
			dPreviousAngle = Math.PI / 2; // 90 degrees
		else
			dPreviousAngle = Math.atan(dPreviousOpposite / dPreviousAdjacent);
		
		if (dPreviousAngle < 0)
			dPreviousAngle = Math.PI + dPreviousAngle;
		
		double dAdjacent = (dTemp2 - dTemp1) / dMaxRampRate;
		double dOpposite = dTime2 - dTime1;
		double dNewAngle;
		if (dAdjacent == 0)
			dNewAngle = Math.PI / 2; // 90 degrees
		else
			dNewAngle = Math.atan(dOpposite / dAdjacent);
		
		if (dNewAngle < 0)
			dNewAngle = Math.PI + dNewAngle;
		
		double dFactor1 = 1;
		double dAngleError = Math.pow((Math.abs(dNewAngle - dPreviousAngle) / (Math.PI)) * dFactor1, 2) + 1;
    	return dAngleError;
    }*/
    
 	public double goldenSectioningSearchGradientProfile(int iIndex, double dStep, double dPrecision, double dMaxChangeAtOnce, boolean bMinimizeAngles)
 	{
		double dRetentionError = 1;
		double x1;
		double x2;
		double x3;
		double dRetentionErrorX1;
		double dRetentionErrorX2;
		double dRetentionErrorX3;
		double dAngleErrorX1;
		double dAngleErrorX2;
		double dAngleErrorX3;
		
		double dLastTempGuess = m_dGradientProfileArray[iIndex][1];
		
		// Find bounds
		x1 = m_dGradientProfileArray[iIndex][1];
		dRetentionErrorX1 = calcRetentionError(m_dtstep, m_vectCalCompounds.size());
		if (bMinimizeAngles)
			dAngleErrorX1 = calcAngleDifferenceGradient(iIndex);
		else
			dAngleErrorX1 = 1;
		
		x2 = x1 + dStep;
		m_dGradientProfileArray[iIndex][1] = x2;
		m_InterpolatedGradientProfile = new InterpolationFunction(m_dGradientProfileArray);
		dRetentionErrorX2 = calcRetentionError(m_dtstep, m_vectCalCompounds.size());
		if (bMinimizeAngles)
			dAngleErrorX2 = calcAngleDifferenceGradient(iIndex);
		else
			dAngleErrorX2 = 1;
		
		if (dRetentionErrorX2 * dAngleErrorX2 < dRetentionErrorX1 * dAngleErrorX1)
		{
			// We're going in the right direction
			x3 = x2;
			dRetentionErrorX3 = dRetentionErrorX2;
			dAngleErrorX3 = dAngleErrorX2;
			
			x2 = (x3 - x1) * this.m_dGoldenRatio + x3;
			
			m_dGradientProfileArray[iIndex][1] = x2;
			m_InterpolatedGradientProfile = new InterpolationFunction(m_dGradientProfileArray);
			dRetentionErrorX2 = calcRetentionError(m_dtstep, m_vectCalCompounds.size());
			if (bMinimizeAngles)
				dAngleErrorX2 = calcAngleDifferenceGradient(iIndex);
			else
				dAngleErrorX2 = 1;
			

			while (dRetentionErrorX2 * dAngleErrorX2 < dRetentionErrorX3 * dAngleErrorX3 && x2 < dLastTempGuess + dMaxChangeAtOnce)
			{
				x1 = x3;
				dRetentionErrorX1 = dRetentionErrorX3;
				dAngleErrorX1 = dAngleErrorX3;
				x3 = x2;
				dRetentionErrorX3 = dRetentionErrorX2;
				dAngleErrorX3 = dAngleErrorX2;
				
				x2 = (x3 - x1) * this.m_dGoldenRatio + x3;
				
				m_dGradientProfileArray[iIndex][1] = x2;
				m_InterpolatedGradientProfile = new InterpolationFunction(m_dGradientProfileArray);
				dRetentionErrorX2 = calcRetentionError(m_dtstep, m_vectCalCompounds.size());
				if (bMinimizeAngles)
					dAngleErrorX2 = calcAngleDifferenceGradient(iIndex);
				else
					dAngleErrorX2 = 1;
			}
		}
		else
		{
			// We need to go in the opposite direction
			x3 = x1;
			dRetentionErrorX3 = dRetentionErrorX1;
			dAngleErrorX3 = dAngleErrorX1;
			
			x1 = x3 - (x2 - x3) * this.m_dGoldenRatio;
			
			m_dGradientProfileArray[iIndex][1] = x1;
			m_InterpolatedGradientProfile = new InterpolationFunction(m_dGradientProfileArray);
			dRetentionErrorX1 = calcRetentionError(m_dtstep, m_vectCalCompounds.size());
			if (bMinimizeAngles)
				dAngleErrorX1 = calcAngleDifferenceGradient(iIndex);
			else
				dAngleErrorX1 = 1;

			while (dRetentionErrorX1 * dAngleErrorX1 < dRetentionErrorX3 * dAngleErrorX3 && x1 > dLastTempGuess - dMaxChangeAtOnce)
			{
				x2 = x3;
				dRetentionErrorX2 = dRetentionErrorX3;
				dAngleErrorX2 = dAngleErrorX3;
				x3 = x1;
				dRetentionErrorX3 = dRetentionErrorX1;
				dAngleErrorX3 = dAngleErrorX1;

				x1 = x3 - (x2 - x3) * this.m_dGoldenRatio;
				
				m_dGradientProfileArray[iIndex][1] = x1;
				m_InterpolatedGradientProfile = new InterpolationFunction(m_dGradientProfileArray);
				dRetentionErrorX1 = calcRetentionError(m_dtstep, m_vectCalCompounds.size());
				if (bMinimizeAngles)
					dAngleErrorX1 = calcAngleDifferenceGradient(iIndex);
				else
					dAngleErrorX1 = 1;
			}
		}
		
		// Now we have our bounds (x1 to x2) and the results of one guess (x3)
		if (x2 > dLastTempGuess + dMaxChangeAtOnce)
		{
			if (dLastTempGuess + dMaxChangeAtOnce > 100)
				m_dGradientProfileArray[iIndex][1] = 100;
			else
				m_dGradientProfileArray[iIndex][1] = dLastTempGuess + dMaxChangeAtOnce;
			
			m_InterpolatedGradientProfile = new InterpolationFunction(m_dGradientProfileArray);
			dRetentionError = calcRetentionError(m_dtstep, m_vectCalCompounds.size());

			return dRetentionError;
		}
		
		if (x1 < dLastTempGuess - dMaxChangeAtOnce)
		{
			if (dLastTempGuess - dMaxChangeAtOnce < 0)
				m_dGradientProfileArray[iIndex][1] = 0;
			else
				m_dGradientProfileArray[iIndex][1] = dLastTempGuess - dMaxChangeAtOnce;
			
			m_InterpolatedGradientProfile = new InterpolationFunction(m_dGradientProfileArray);
			dRetentionError = calcRetentionError(m_dtstep, m_vectCalCompounds.size());
			
			return dRetentionError;
		}
		
		// Loop of optimization
		while ((x2 - x1) > dPrecision)
		{
			double x4;
			double dRetentionErrorX4;
			double dAngleErrorX4;
			
			// Is the bigger gap between x3 and x2 or x3 and x1?
			if (x2 - x3 > x3 - x1) 
			{
				// x3 and x2, so x4 must be placed between them
				x4 = x3 + (2 - this.m_dGoldenRatio) * (x2 - x3);
			}
			else 
			{
				// x1 and x3, so x4 must be placed between them
				x4 = x3 - (2 - this.m_dGoldenRatio) * (x3 - x1);
			}

			
			m_dGradientProfileArray[iIndex][1] = x4;
			m_InterpolatedGradientProfile = new InterpolationFunction(m_dGradientProfileArray);
			dRetentionErrorX4 = calcRetentionError(m_dtstep, m_vectCalCompounds.size());
			if (bMinimizeAngles)
				dAngleErrorX4 = calcAngleDifferenceGradient(iIndex);
			else
				dAngleErrorX4 = 1;
			
			// Decide what to do next
			if (dRetentionErrorX4 * dAngleErrorX4 < dRetentionErrorX3 * dAngleErrorX3)
			{
				// Our new guess was better
				// Where did we put our last guess again?
				if (x2 - x3 > x3 - x1) 
				{
					// x4 was in between x3 and x2
					x1 = x3;
					dRetentionErrorX1 = dRetentionErrorX3;
					dAngleErrorX1 = dAngleErrorX3;
					x3 = x4;
					dRetentionErrorX3 = dRetentionErrorX4;
					dAngleErrorX3 = dAngleErrorX4;
				}
				else
				{
					// x4 was in between x1 and x3
					x2 = x3;
					dRetentionErrorX2 = dRetentionErrorX3;							
					dAngleErrorX2 = dAngleErrorX3;
					x3 = x4;
					dRetentionErrorX3 = dRetentionErrorX4;
					dAngleErrorX3 = dAngleErrorX4;
				}
			}
			else
			{
				// Our new guess was worse
				if (x2 - x3 > x3 - x1) 
				{
					// x4 was in between x3 and x2
					x2 = x4;
					dRetentionErrorX2 = dRetentionErrorX4;
					dAngleErrorX2 = dAngleErrorX4;
				}
				else
				{
					// x4 was in between x1 and x3
					x1 = x4;
					dRetentionErrorX1 = dRetentionErrorX4;							
					dAngleErrorX1 = dAngleErrorX4;
				}
			}
		}
		
		// Restore profile to best value
		if (x3 > 100)
		{
			m_dGradientProfileArray[iIndex][1] = 100;
			m_InterpolatedGradientProfile = new InterpolationFunction(m_dGradientProfileArray);
			dRetentionError = calcRetentionError(m_dtstep, m_vectCalCompounds.size());			
		}
		else if (x3 < 0)
		{
			m_dGradientProfileArray[iIndex][1] = 0;
			m_InterpolatedGradientProfile = new InterpolationFunction(m_dGradientProfileArray);
			dRetentionError = calcRetentionError(m_dtstep, m_vectCalCompounds.size());			
		}
		else
		{
			m_dGradientProfileArray[iIndex][1] = x3;
			m_InterpolatedGradientProfile = new InterpolationFunction(m_dGradientProfileArray);
			dRetentionError = dRetentionErrorX3;			
		}
 		
 		return dRetentionError;
 	}
 	
 	public double goldenSectioningSearchHoldUp(int iIndex, double dStep, double dPrecision, double dMaxChangeAtOnce, boolean bMinimizeAngles)
 	{
		double dRetentionError = 1;
		double x1;
		double x2;
		double x3;
		double dRetentionErrorX1;
		double dRetentionErrorX2;
		double dRetentionErrorX3;
		double dAngleErrorX1;
		double dAngleErrorX2;
		double dAngleErrorX3;
		
		double dLastFGuess = m_dFlowRateArray[iIndex][1];

		// Find bounds
		x1 = this.m_dFlowRateArray[iIndex][1];
		dRetentionErrorX1 = calcRetentionError(m_dtstep, m_vectCalCompounds.size());
		if (bMinimizeAngles)
			dAngleErrorX1 = calcAngleDifferenceFlowRate(iIndex);
		else
			dAngleErrorX1 = 1;
		
		x2 = x1 + dStep;
		m_dFlowRateArray[iIndex][1] = x2;
		this.m_InterpolatedFlowRate = new InterpolationFunction(m_dFlowRateArray);
		dRetentionErrorX2 = calcRetentionError(m_dtstep, m_vectCalCompounds.size());
		if (bMinimizeAngles)
			dAngleErrorX2 = calcAngleDifferenceFlowRate(iIndex);
		else
			dAngleErrorX2 = 1;
		
		if (dRetentionErrorX2 * dAngleErrorX2 < dRetentionErrorX1 * dAngleErrorX1)
		{
			// We're going in the right direction
			x3 = x2;
			dRetentionErrorX3 = dRetentionErrorX2;
			dAngleErrorX3 = dAngleErrorX2;
			
			x2 = (x3 - x1) * this.m_dGoldenRatio + x3;
			
			m_dFlowRateArray[iIndex][1] = x2;
			m_InterpolatedFlowRate = new InterpolationFunction(m_dFlowRateArray);
			dRetentionErrorX2 = calcRetentionError(m_dtstep, m_vectCalCompounds.size());
			if (bMinimizeAngles)
				dAngleErrorX2 = calcAngleDifferenceFlowRate(iIndex);
			else
				dAngleErrorX2 = 1;

			while (dRetentionErrorX2 * dAngleErrorX2 < dRetentionErrorX3 * dAngleErrorX3 && x2 < dLastFGuess + dMaxChangeAtOnce)
			{
				x1 = x3;
				dRetentionErrorX1 = dRetentionErrorX3;
				dAngleErrorX1 = dAngleErrorX3;
				
				x3 = x2;
				dRetentionErrorX3 = dRetentionErrorX2;
				dAngleErrorX3 = dAngleErrorX2;
				
				x2 = (x3 - x1) * this.m_dGoldenRatio + x3;
				
				m_dFlowRateArray[iIndex][1] = x2;
				m_InterpolatedFlowRate = new InterpolationFunction(m_dFlowRateArray);
				dRetentionErrorX2 = calcRetentionError(m_dtstep, m_vectCalCompounds.size());
				if (bMinimizeAngles)
					dAngleErrorX2 = calcAngleDifferenceFlowRate(iIndex);
				else
					dAngleErrorX2 = 1;
			}
		}
		else
		{
			// We need to go in the opposite direction
			x3 = x1;
			dRetentionErrorX3 = dRetentionErrorX1;
			dAngleErrorX3 = dAngleErrorX1;
			
			x1 = x3 - (x2 - x3) * this.m_dGoldenRatio;
			
			m_dFlowRateArray[iIndex][1] = x1;
			m_InterpolatedFlowRate = new InterpolationFunction(m_dFlowRateArray);
			dRetentionErrorX1 = calcRetentionError(m_dtstep, m_vectCalCompounds.size());
			if (bMinimizeAngles)
				dAngleErrorX1 = calcAngleDifferenceFlowRate(iIndex);
			else
				dAngleErrorX1 = 1;

			while (dRetentionErrorX1 * dAngleErrorX1 < dRetentionErrorX3 * dAngleErrorX3 && x1 > dLastFGuess - dMaxChangeAtOnce)
			{
				x2 = x3;
				dRetentionErrorX2 = dRetentionErrorX3;
				dAngleErrorX2 = dAngleErrorX3;
				x3 = x1;
				dRetentionErrorX3 = dRetentionErrorX1;
				dAngleErrorX3 = dAngleErrorX1;
				
				x1 = x3 - (x2 - x3) * this.m_dGoldenRatio;
				
				m_dFlowRateArray[iIndex][1] = x1;
				m_InterpolatedFlowRate = new InterpolationFunction(m_dFlowRateArray);
				dRetentionErrorX1 = calcRetentionError(m_dtstep, m_vectCalCompounds.size());
				if (bMinimizeAngles)
					dAngleErrorX1 = calcAngleDifferenceFlowRate(iIndex);
				else
					dAngleErrorX1 = 1;
			}
		}
		
		// Now we have our bounds (x1 to x2) and the results of one guess (x3)
		if (x2 > dLastFGuess + dMaxChangeAtOnce)
		{
			m_dFlowRateArray[iIndex][1] = dLastFGuess + dMaxChangeAtOnce;
			m_InterpolatedFlowRate = new InterpolationFunction(m_dFlowRateArray);
			dRetentionError = calcRetentionError(m_dtstep, m_vectCalCompounds.size());
			
			return dRetentionError;
		}
		
		if (x1 < dLastFGuess - dMaxChangeAtOnce)
		{
			m_dFlowRateArray[iIndex][1] = dLastFGuess - dMaxChangeAtOnce;
			m_InterpolatedFlowRate = new InterpolationFunction(m_dFlowRateArray);
			dRetentionError = calcRetentionError(m_dtstep, m_vectCalCompounds.size());

			return dRetentionError;
		}
		
		// Loop of optimization
		while ((x2 - x1) > dPrecision)
		{
			double x4;
			double dRetentionErrorX4;
			double dAngleErrorX4;
			
			// Is the bigger gap between x3 and x2 or x3 and x1?
			if (x2 - x3 > x3 - x1) 
			{
				// x3 and x2, so x4 must be placed between them
				x4 = x3 + (2 - this.m_dGoldenRatio) * (x2 - x3);
			}
			else 
			{
				// x1 and x3, so x4 must be placed between them
				x4 = x3 - (2 - this.m_dGoldenRatio) * (x3 - x1);
			}
			
			m_dFlowRateArray[iIndex][1] = x4;
			m_InterpolatedFlowRate = new InterpolationFunction(m_dFlowRateArray);
			dRetentionErrorX4 = calcRetentionError(m_dtstep, m_vectCalCompounds.size());
			if (bMinimizeAngles)
				dAngleErrorX4 = calcAngleDifferenceFlowRate(iIndex);
			else
				dAngleErrorX4 = 1;

			// Decide what to do next
			if (dRetentionErrorX4 * dAngleErrorX4 < dRetentionErrorX3 * dAngleErrorX3)
			{
				// Our new guess was better
				// Where did we put our last guess again?
				if (x2 - x3 > x3 - x1) 
				{
					// x4 was in between x3 and x2
					x1 = x3;
					dRetentionErrorX1 = dRetentionErrorX3;
					dAngleErrorX1 = dAngleErrorX3;
					x3 = x4;
					dRetentionErrorX3 = dRetentionErrorX4;
					dAngleErrorX3 = dAngleErrorX4;
				}
				else
				{
					// x4 was in between x1 and x3
					x2 = x3;
					dRetentionErrorX2 = dRetentionErrorX3;
					dAngleErrorX2 = dAngleErrorX3;
					x3 = x4;
					dRetentionErrorX3 = dRetentionErrorX4;
					dAngleErrorX3 = dAngleErrorX4;
				}
			}
			else
			{
				// Our new guess was worse
				if (x2 - x3 > x3 - x1) 
				{
					// x4 was in between x3 and x2
					x2 = x4;
					dRetentionErrorX2 = dRetentionErrorX4;
					dAngleErrorX2 = dAngleErrorX4;
				}
				else
				{
					// x4 was in between x1 and x3
					x1 = x4;
					dRetentionErrorX1 = dRetentionErrorX4;
					dAngleErrorX1 = dAngleErrorX4;
				}
			}
		}
		
		// Restore profile to best value
		m_dFlowRateArray[iIndex][1] = x3;
		m_InterpolatedFlowRate = new InterpolationFunction(m_dFlowRateArray);
		dRetentionError = dRetentionErrorX3;
		
		return dRetentionError;
 	}
    
 	public double goldenSectioningSearchHoldUpOffset(double dStep, double dPrecision, int iNumCompoundsToUse)
 	{
		double dRetentionError = 1;
 		double F1;
		double F2;
		double F3;
		double dRetentionErrorF1;
		double dRetentionErrorF2;
		double dRetentionErrorF3;
		
		// Find bounds
		F1 = m_dFlowRateArray[0][1];
		dRetentionErrorF1 = calcRetentionError(m_dtstep, iNumCompoundsToUse);

		F2 = F1 + dStep;
		
		double dDiff = F2 - m_dFlowRateArray[0][1];
		for (int i = 0; i < m_dFlowRateArray.length; i++)
		{
			m_dFlowRateArray[i][1] += dDiff;
		}
		m_InterpolatedFlowRate = new InterpolationFunction(m_dFlowRateArray);
		dRetentionErrorF2 = calcRetentionError(m_dtstep, iNumCompoundsToUse);
		
		if (dRetentionErrorF2 < dRetentionErrorF1)
		{
			// We're going in the right direction
			F3 = F2;
			dRetentionErrorF3 = dRetentionErrorF2;
			
			F2 = (F3 - F1) * this.m_dGoldenRatio + F3;
			
			dDiff = F2 - m_dFlowRateArray[0][1];
			for (int i = 0; i < m_dFlowRateArray.length; i++)
			{
				m_dFlowRateArray[i][1] += dDiff;
			}
			m_InterpolatedFlowRate = new InterpolationFunction(m_dFlowRateArray);
			dRetentionErrorF2 = calcRetentionError(m_dtstep, iNumCompoundsToUse);

			while (dRetentionErrorF2 < dRetentionErrorF3)
			{
				F1 = F3;
				dRetentionErrorF1 = dRetentionErrorF3;
				F3 = F2;
				dRetentionErrorF3 = dRetentionErrorF2;
				
				F2 = (F3 - F1) * this.m_dGoldenRatio + F3;
				
				dDiff = F2 - m_dFlowRateArray[0][1];
				for (int i = 0; i < m_dFlowRateArray.length; i++)
				{
					m_dFlowRateArray[i][1] += dDiff;
				}
				m_InterpolatedFlowRate = new InterpolationFunction(m_dFlowRateArray);
				dRetentionErrorF2 = calcRetentionError(m_dtstep, iNumCompoundsToUse);
			}
		}
		else
		{
			// We need to go in the opposite direction
			F3 = F1;
			dRetentionErrorF3 = dRetentionErrorF1;
			
			F1 = F3 - (F2 - F3) * this.m_dGoldenRatio;
			
			dDiff = F1 - m_dFlowRateArray[0][1];
			for (int i = 0; i < m_dFlowRateArray.length; i++)
			{
				m_dFlowRateArray[i][1] += dDiff;
			}
			m_InterpolatedFlowRate = new InterpolationFunction(m_dFlowRateArray);
			dRetentionErrorF1 = calcRetentionError(m_dtstep, iNumCompoundsToUse);

			while (dRetentionErrorF1 < dRetentionErrorF3)
			{
				F2 = F3;
				dRetentionErrorF2 = dRetentionErrorF3;
				F3 = F1;
				dRetentionErrorF3 = dRetentionErrorF1;
				
				F1 = F3 - (F2 - F3) * this.m_dGoldenRatio;
				
				dDiff = F1 - m_dFlowRateArray[0][1];
				for (int i = 0; i < m_dFlowRateArray.length; i++)
				{
					m_dFlowRateArray[i][1] += dDiff;
				}
				m_InterpolatedFlowRate = new InterpolationFunction(m_dFlowRateArray);
				dRetentionErrorF1 = calcRetentionError(m_dtstep, iNumCompoundsToUse);
			}
		}
		
		// Loop of optimization
		while ((F2 - F1) > dPrecision)
		{
			double F4;
			double dRetentionErrorF4;
			// Is the bigger gap between F3 and F2 or F3 and F1?
			if (F2 - F3 > F3 - F1) 
			{
				// F3 and F2, so F4 must be placed between them
				F4 = F3 + (2 - this.m_dGoldenRatio) * (F2 - F3);
			}
			else 
			{
				// F1 and F3, so F4 must be placed between them
				F4 = F3 - (2 - this.m_dGoldenRatio) * (F3 - F1);
			}

			
			dDiff = F4 - m_dFlowRateArray[0][1];
			for (int i = 0; i < m_dFlowRateArray.length; i++)
			{
				m_dFlowRateArray[i][1] += dDiff;
			}
			m_InterpolatedFlowRate = new InterpolationFunction(m_dFlowRateArray);
			dRetentionErrorF4 = calcRetentionError(m_dtstep, iNumCompoundsToUse);
			
			// Decide what to do next
			if (dRetentionErrorF4 < dRetentionErrorF3)
			{
				// Our new guess was better
				// Where did we put our last guess again?
				if (F2 - F3 > F3 - F1) 
				{
					// F4 was in between F3 and F2
					F1 = F3;
					dRetentionErrorF1 = dRetentionErrorF3;
					F3 = F4;
					dRetentionErrorF3 = dRetentionErrorF4;
				}
				else
				{
					// F4 was in between F1 and F3
					F2 = F3;
					dRetentionErrorF2 = dRetentionErrorF3;							
					F3 = F4;
					dRetentionErrorF3 = dRetentionErrorF4;
				}
			}
			else
			{
				// Our new guess was worse
				if (F2 - F3 > F3 - F1) 
				{
					// F4 was in between F3 and F2
					F2 = F4;
					dRetentionErrorF2 = dRetentionErrorF4;
				}
				else
				{
					// F4 was in between F1 and F3
					F1 = F4;
					dRetentionErrorF1 = dRetentionErrorF4;							
				}
			}
		}
		
		dRetentionError = dRetentionErrorF3;
		
		return dRetentionError;
 	}
 	
    // Iterative - in sequence, *Golden* Sectioning Search algorithm
    // Start by optimizing the entire flow rate error profile.
	public void backCalculate(Task task, boolean bHoldUpProfileFirst)
	{
		//if (true)
		//	return;
		long starttime = System.currentTimeMillis();

		m_dGradientArrayStore = new double[300][m_dGradientProfileArray.length][2];
		m_dFlowRateArrayStore = new double[300][m_dFlowRateArray.length][2];
		m_dRetentionErrorStore = new double[300];
		
		boolean bBackCalculateGradientProfile = false;
		boolean bBackCalculateFlowRateProfile = false;
		boolean bMinimizeAnglesGradientProfile = true;
		boolean bMinimizeAnglesFlowRateProfile = true;
		
		m_Vm = new InterpolationFunction(this.m_dDeadVolumeArray);

    	m_dtstep = m_dPlotXMax2 * 0.01;

		if (bHoldUpProfileFirst)
		{
			bBackCalculateGradientProfile = false;
			bBackCalculateFlowRateProfile = true;
		}
		else
		{
			bBackCalculateGradientProfile = true;
			bBackCalculateFlowRateProfile = false;
		}
		
		NumberFormat formatter1 = new DecimalFormat("#0.000000");
		NumberFormat formatter2 = new DecimalFormat("0.0000E0");
		NumberFormat percentFormatter = new DecimalFormat("0.00");
		
		// Step #1: Create interpolating functions for the isocratic data of each gradient calibration solute
		m_StandardIsocraticDataInterpolated = new InterpolationFunction[contentPane2.tmOutputModel.getRowCount()];
		
		for (int i = 0; i < m_StandardIsocraticDataInterpolated.length; i++)
		{
			Integer iIndex = (Integer) m_vectCalCompounds.get(i)[0];
			m_StandardIsocraticDataInterpolated[i] = new InterpolationFunction(Globals.StandardIsocraticDataArray[iIndex]);
		}

		// Step #2: Optimize the flow rate profile offset
		if (false)
		{
			double dHoldUpStep = this.m_dFlowRate / 100;
			double dHoldUpPrecision = this.m_dFlowRate / 100000;
			int iNumCompoundsToUse = 3;
			
			double dRetentionError = goldenSectioningSearchHoldUpOffset(dHoldUpStep, dHoldUpPrecision, iNumCompoundsToUse);
			
			updateTime(starttime);
			
			String str;
			double dNum = dRetentionError / m_vectCalCompounds.size();
			if (dNum < 0.0001)
				str = formatter2.format(dNum);
			else
				str = formatter1.format(dNum);
			
			contentPane2.jlblVariance.setText(str);
			this.updateGraphs(true);
			
			if (task.isCancelled())
			{
				return;
			}
		}
		
		// Step #4: Begin back-calculation
		// If bHoldUpProfileFirst then back-calculate the flow rate profile first, otherwise do the gradient profile first
		
		int iPhase = 1;
		int iIteration = 0;
		double dLastFullIterationError = 0;
		double dRetentionError = 0;
		
		while (true)
		{
			iIteration++;
			contentPane2.jlblIterationNumber.setText(((Integer)iIteration).toString());
			dLastFullIterationError = dRetentionError;
			
			// Run once for each data point. Start with the earliest data point.
			
			// Now we optimize the hold-up time vs. temp profile
			if (bBackCalculateFlowRateProfile)
			{
				for (int iTimePoint = 0; iTimePoint < m_dFlowRateArray.length; iTimePoint++)
				{
					double dHoldUpStep = this.m_dFlowRate / 1000;
					double dHoldUpPrecision = this.m_dFlowRate / 100000;
					double dMaxChangeAtOnce = this.m_dFlowRate / 20;
					
					dRetentionError = goldenSectioningSearchHoldUp(iTimePoint, dHoldUpStep, dHoldUpPrecision, dMaxChangeAtOnce, bMinimizeAnglesFlowRateProfile);
					
					updateTime(starttime);
					
					String str;
					double dNum = dRetentionError / m_vectCalCompounds.size();
					if (dNum < 0.0001)
						str = formatter2.format(dNum);
					else
						str = formatter1.format(dNum);
					
					contentPane2.jlblVariance.setText(str);
					this.updateGraphs(true);

					if (task.isCancelled())
					{
						return;
					}
				}
			}
			
			if (bBackCalculateGradientProfile)
			{
				for (int iTimePoint = 0; iTimePoint < m_dGradientProfileArray.length; iTimePoint++)
				{
					double dPercentBStep = .1;
					double dMaxChangeAtOnce = 2;
					double dPercentBPrecision = 0.001;
					
					dRetentionError = goldenSectioningSearchGradientProfile(iTimePoint, dPercentBStep, dPercentBPrecision, dMaxChangeAtOnce, bMinimizeAnglesGradientProfile);
					
					updateTime(starttime);
					
					String str;
					double dNum = dRetentionError / m_vectCalCompounds.size();
					if (dNum < 0.0001)
						str = formatter2.format(dNum);
					else
						str = formatter1.format(dNum);
					
					contentPane2.jlblVariance.setText(str);
					this.updateGraphs(true);

					if (task.isCancelled())
					{
						return;
					}
				}
			}
			
			String str;
			double dNum = dRetentionError / m_vectCalCompounds.size();
			
			if (dNum == 0)
				str = "";
			else if (dNum < 0.0001)
				str = formatter2.format(dNum);
			else
				str = formatter1.format(dNum);
			
			contentPane2.jlblLastVariance.setText(str);
			
			{
				// Save the new gradient profile
				for (int i = 0; i < m_dGradientProfileArray.length; i++)
				{
					m_dGradientArrayStore[iIteration - 1][i][0] = m_dGradientProfileArray[i][0];
					m_dGradientArrayStore[iIteration - 1][i][1] = m_dGradientProfileArray[i][1];
				}
	
				// Save the new flow rate profile
				for (int i = 0; i < m_dFlowRateArray.length; i++)
				{
					m_dFlowRateArrayStore[iIteration - 1][i][0] = m_dFlowRateArray[i][0];
					m_dFlowRateArrayStore[iIteration - 1][i][1] = m_dFlowRateArray[i][1];
				}
				
				// Save the retention error for this iteration
				m_dRetentionErrorStore[iIteration - 1] = dRetentionError;
			}
			
			// Calculate the percent improvement
			if (dLastFullIterationError != 0)
			{
				double dPercentImprovement = (1 - (dRetentionError / dLastFullIterationError)) * 100;
				contentPane2.jlblPercentImprovement.setText(percentFormatter.format(dPercentImprovement) + "%");
				
				if (iPhase == 1)
				{
					/*if (bHoldUpProfileFirst)
					{
						if (dPercentImprovement < 1 && dPercentImprovement >= 0)
						{
							iPhase = 2;
							contentPane2.jlblPhase.setText("II");
							bBackCalculateGradientProfile = true;
							bBackCalculateFlowRateProfile = true;
							bMinimizeAnglesGradientProfile = true;
							bMinimizeAnglesFlowRateProfile = true;
						}
					}
					else
					{*/
						if (dPercentImprovement < 1 && dPercentImprovement >= 0 && dLastFullIterationError - dRetentionError < .001)
						{
							iPhase = 2;
							contentPane2.jlblPhase.setText("II");
							bBackCalculateGradientProfile = true;
							bBackCalculateFlowRateProfile = false;
							bMinimizeAnglesGradientProfile = true;
							bMinimizeAnglesFlowRateProfile = true;
					    	m_dtstep = m_dPlotXMax2 * 0.001;

						}
					//}
				}
				else if (iPhase == 2)
				{
					if (dPercentImprovement < 2 && dPercentImprovement >= 0)
					{
						iPhase = 3;
						contentPane2.jlblPhase.setText("III");
						if (bHoldUpProfileFirst)
						{
							bBackCalculateGradientProfile = true;
							bBackCalculateFlowRateProfile = true;
						}
						else
						{
							bBackCalculateGradientProfile = true;
							bBackCalculateFlowRateProfile = true;
						}
						bMinimizeAnglesGradientProfile = false;
						bMinimizeAnglesFlowRateProfile = false;
				    	m_dtstep = m_dPlotXMax2 * 0.001;
					}					
				}
				else
				{
					if (dPercentImprovement < 2 && dPercentImprovement >= 0)
					{
						// Optimization is complete.
						break;
					}
				}
			}
		}
	}

	@Override
	public void lostOwnership(Clipboard arg0, Transferable arg1) {
		// TODO Auto-generated method stub
		
	}
}
